// EliteEstates Theme JavaScript - Professional Real Estate
document.addEventListener('DOMContentLoaded', function() {
    console.log('🏠 EliteEstates Theme Loaded Successfully!');
    
    // Header scroll effect
    const header = document.getElementById('mainHeader');
    if (header) {
        window.addEventListener('scroll', function() {
            if (window.scrollY > 50) {
                header.classList.add('header-scrolled');
            } else {
                header.classList.remove('header-scrolled');
            }
        });
    }
    
    // Property search functionality
    const searchBtn = document.querySelector('.search-btn');
    if (searchBtn) {
        searchBtn.addEventListener('click', function() {
            const propertyType = document.getElementById('property-type');
            const priceRange = document.getElementById('price-range');
            const location = document.getElementById('location');
            
            if (propertyType && priceRange && location) {
                const searchData = {
                    type: propertyType.value,
                    price: priceRange.value,
                    location: location.value
                };
                
                console.log('Property Search:', searchData);
                
                if (!searchData.location && !searchData.type && !searchData.price) {
                    alert('🔍 Please enter search criteria to find properties');
                } else {
                    alert(`🏠 Searching for ${searchData.type || 'any'} properties in ${searchData.location || 'any location'} within ${searchData.price || 'any price range'}`);
                }
            }
        });
    }
    
    // Smooth scrolling for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
    
    // Property card interactions
    document.querySelectorAll('.property-card').forEach(card => {
        card.addEventListener('click', function() {
            const propertyTitle = this.querySelector('.property-title');
            const propertyPrice = this.querySelector('.property-price');
            
            if (propertyTitle && propertyPrice) {
                console.log('Property Selected:', {
                    title: propertyTitle.textContent,
                    price: propertyPrice.textContent
                });
            }
        });
    });
    
    // View details buttons
    document.querySelectorAll('.btn-view').forEach(button => {
        button.addEventListener('click', function(e) {
            e.stopPropagation();
            const card = this.closest('.property-card');
            const title = card.querySelector('.property-title');
            console.log('Viewing details for:', title?.textContent);
        });
    });
    
    // Mobile menu functionality (can be added later)
    initializeMobileMenu();
});

function initializeMobileMenu() {
    // Mobile menu implementation can be added here
    console.log('Mobile menu ready for implementation');
}

// Utility functions
function formatCurrency(amount) {
    return new Intl.NumberFormat('en-US', {
        style: 'currency',
        currency: 'USD'
    }).format(amount);
}

function debounce(func, wait) {
    let timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}